---@meta

---@class FSoundscapeColorModulationSettings
---@field bRandomizeVolume boolean
---@field VolumeMin float
---@field VolumeMax float
---@field bRandomizePitch boolean
---@field PitchMin float
---@field PitchMax float
---@field bFadeVolume boolean
---@field MinFadeInTime float
---@field MaxFadeInTime float
---@field MinFadeOutTime float
---@field MaxFadeOutTime float
---@field bOnlyFadeInOnRetrigger boolean
local FSoundscapeColorModulationSettings = {}



---@class FSoundscapeColorPlaybackSettings
---@field bRandomizeStartingSeekTime boolean
---@field bLimitPlaybackDuration boolean
---@field MinPlaybackDuration float
---@field MaxPlaybackDuration float
local FSoundscapeColorPlaybackSettings = {}



---@class FSoundscapeColorPoint
---@field ColorPoint FGameplayTag
---@field Location FVector
local FSoundscapeColorPoint = {}



---@class FSoundscapeColorPointCollection
---@field ColorPointCollection TArray<FSoundscapeColorPointVectorArray>
local FSoundscapeColorPointCollection = {}



---@class FSoundscapeColorPointVectorArray
---@field ColorPoint FGameplayTag
---@field Locations TArray<FVector>
local FSoundscapeColorPointVectorArray = {}



---@class FSoundscapeColorSpawnSettings
---@field bDelayFirstSpawn boolean
---@field MinFirstSpawnDelay float
---@field MaxFirstSpawnDelay float
---@field bContinuouslyRespawn boolean
---@field MinSpawnDelay float
---@field MaxSpawnDelay float
---@field MaxNumberOfSpawnedElements int32
---@field MinSpawnDistance float
---@field MaxSpawnDistance float
---@field bCullByMaxSpawnDistance boolean
---@field MinSpawnAngle float
---@field MaxSpawnAngle float
---@field bClampHeight boolean
---@field ClampMode ESoundscapeColorAltitudeClampMode
---@field MinSpawnHeightClamp float
---@field MaxSpawnHeightClamp float
---@field bRotateSoundSource boolean
---@field MinAzimuthalRotationAngle float
---@field MaxAzimuthalRotationAngle float
---@field MinAltitudinalRotationAngle float
---@field MaxAltitudinalRotationAngle float
---@field bPositionByTrace boolean
---@field TraceVector FVector
---@field TraceDistance float
---@field TraceChannel ECollisionChannel
---@field bFilterByColorPointDensity boolean
---@field ColorPoint FGameplayTag
---@field MinColorPointNumber int32
---@field bIgnoreZAxisWhenCullingByMaxDistance boolean
local FSoundscapeColorSpawnSettings = {}



---@class FSoundscapeColorVoiceParams
local FSoundscapeColorVoiceParams = {}


---@class FSoundscapePaletteCollection
---@field SoundscapePaletteCollection TSet<FSoftObjectPath>
local FSoundscapePaletteCollection = {}



---@class FSoundscapePaletteCollectionLoaded
---@field SoundscapePaletteCollection TSet<USoundscapePalette>
local FSoundscapePaletteCollectionLoaded = {}



---@class FSoundscapePaletteColor
---@field SoundscapeColor USoundscapeColor
---@field ColorVolume float
---@field ColorPitch float
---@field ColorFadeIn float
---@field ColorFadeOut float
local FSoundscapePaletteColor = {}



---@class UActiveSoundscapeColor : UObject
---@field Sound USoundBase
---@field ModulationBehavior FSoundscapeColorModulationSettings
---@field PlaybackBehavior FSoundscapeColorPlaybackSettings
---@field SpawnBehavior FSoundscapeColorSpawnSettings
---@field SoundscapeColorVoicePool TArray<UActiveSoundscapeColorVoice>
local UActiveSoundscapeColor = {}

function UActiveSoundscapeColor:UpdateSoundscapeColor() end
---@param ColorFadeOutTime float
function UActiveSoundscapeColor:Stop(ColorFadeOutTime) end
---@param ColorVolume float
---@param ColorPitch float
---@param ColorFadeInTime float
function UActiveSoundscapeColor:Play(ColorVolume, ColorPitch, ColorFadeInTime) end
---@return boolean
function UActiveSoundscapeColor:IsPlaying() end


---@class UActiveSoundscapeColorVoice : UObject
---@field AudioComponent UAudioComponent
---@field TimerHandle FTimerHandle
---@field bFree boolean
local UActiveSoundscapeColorVoice = {}

---@param FadeOutTime float
function UActiveSoundscapeColorVoice:StopLimitedDurationVoice(FadeOutTime) end


---@class UActiveSoundscapePalette : UObject
---@field World UWorld
---@field ActiveSoundscapeColors TArray<UActiveSoundscapeColor>
local UActiveSoundscapePalette = {}

function UActiveSoundscapePalette:Stop() end
function UActiveSoundscapePalette:Play() end


---@class USoundscapeBPFunctionLibrary : UBlueprintFunctionLibrary
local USoundscapeBPFunctionLibrary = {}

---@param WorldContextObject UObject
---@param SoundscapePaletteIn USoundscapePalette
---@param SoundscapePaletteAgentsOut UActiveSoundscapePalette
---@return boolean
function USoundscapeBPFunctionLibrary:SpawnSoundscapePalette(WorldContextObject, SoundscapePaletteIn, SoundscapePaletteAgentsOut) end
---@param WorldContextObject UObject
---@param SoundscapeColorIn USoundscapeColor
---@param ActiveSoundscapeColor UActiveSoundscapeColor
---@return boolean
function USoundscapeBPFunctionLibrary:SpawnSoundscapeColor(WorldContextObject, SoundscapeColorIn, ActiveSoundscapeColor) end


---@class USoundscapeColor : UObject
---@field Sound USoundBase
---@field VolumeBase float
---@field PitchBase float
---@field ModulationBehavior FSoundscapeColorModulationSettings
---@field PlaybackBehavior FSoundscapeColorPlaybackSettings
---@field SpawnBehavior FSoundscapeColorSpawnSettings
local USoundscapeColor = {}



---@class USoundscapeColorPointComponent : UActorComponent
---@field ColorPoint FGameplayTag
local USoundscapeColorPointComponent = {}



---@class USoundscapeColorPointHashCellDensity : UObject
---@field ColorPointHashCellDensity TMap<uint64, int32>
local USoundscapeColorPointHashCellDensity = {}



---@class USoundscapeColorPointHashMap : UObject
---@field ColorPointHashMap TMap<FGameplayTag, USoundscapeColorPointHashCellDensity>
---@field HashCellSize float
---@field GridWidth int32
---@field NumCells int64
---@field HashCellFactor float
---@field GridCenter FVector
---@field GridOriginOffset FVector
local USoundscapeColorPointHashMap = {}

---@param Location FVector
function USoundscapeColorPointHashMap:SetGridCenterpoint(Location) end
---@param Location FVector
---@param ColorPoint FGameplayTag
---@return int32
function USoundscapeColorPointHashMap:NumColorPointsInCell(Location, ColorPoint) end
---@param HashCellSizeIn float
---@param GridCenterIn FVector
function USoundscapeColorPointHashMap:InitializeHash(HashCellSizeIn, GridCenterIn) end
function USoundscapeColorPointHashMap:ClearHash() end
---@param Location FVector
---@return uint64
function USoundscapeColorPointHashMap:CalculateHashIndex(Location) end
---@param Location FVector
---@param ColorPoint FGameplayTag
---@return boolean
function USoundscapeColorPointHashMap:AddColorPointToHash(Location, ColorPoint) end
---@param Locations TArray<FVector>
---@param ColorPoint FGameplayTag
function USoundscapeColorPointHashMap:AddColorPointArrayToHash(Locations, ColorPoint) end


---@class USoundscapeColorPointHashMapCollection : UObject
---@field ColorPointHashMapLOD1 USoundscapeColorPointHashMap
---@field ColorPointHashMapLOD2 USoundscapeColorPointHashMap
---@field ColorPointHashMapLOD3 USoundscapeColorPointHashMap
---@field LOD1ColorPointHashWidth float
---@field LOD1ColorPointHashDistance float
---@field LOD2ColorPointHashWidth float
---@field LOD2ColorPointHashDistance float
---@field LOD3ColorPointHashWidth float
local USoundscapeColorPointHashMapCollection = {}



---@class USoundscapePalette : UObject
---@field SoundscapePalettePlaybackConditions FGameplayTagQuery
---@field Colors TArray<FSoundscapePaletteColor>
local USoundscapePalette = {}



---@class USoundscapeSettings : UDeveloperSettings
---@field SoundscapePaletteCollection TSet<FSoftObjectPath>
---@field bDebugDraw boolean
---@field LOD1ColorPointHashWidth float
---@field LOD1ColorPointHashDistance float
---@field LOD2ColorPointHashWidth float
---@field LOD2ColorPointHashDistance float
---@field LOD3ColorPointHashWidth float
---@field ActiveColorPointHashWidth float
---@field ActiveColorPointHashUpdateTimeSeconds float
local USoundscapeSettings = {}



---@class USoundscapeSubsystem : UGameInstanceSubsystem
---@field LoadedPaletteCollectionSet TSet<USoundscapePalette>
---@field UnloadedPaletteCollections TMap<FName, FSoundscapePaletteCollection>
---@field ActivePalettes TMap<USoundscapePalette, UActiveSoundscapePalette>
---@field ColorPointHashMapCollections TArray<USoundscapeColorPointHashMapCollection>
---@field ColorPointHashMapLOD1 USoundscapeColorPointHashMap
---@field ColorPointHashMapLOD2 USoundscapeColorPointHashMap
---@field ColorPointHashMapLOD3 USoundscapeColorPointHashMap
---@field ActiveColorPointHashMap USoundscapeColorPointHashMap
local USoundscapeSubsystem = {}

---@param SoundscapeState FGameplayTag
function USoundscapeSubsystem:SetState(SoundscapeState) end
function USoundscapeSubsystem:RestartSoundscape() end
---@param PaletteCollectionName FName
---@return boolean
function USoundscapeSubsystem:RemovePaletteCollection(PaletteCollectionName) end
---@param ColorPointCollectionName FName
---@return boolean
function USoundscapeSubsystem:RemoveColorPointCollection(ColorPointCollectionName) end
---@param SoundscapeState FGameplayTag
function USoundscapeSubsystem:ClearState(SoundscapeState) end
---@param Location FVector
---@param ColorPoint FGameplayTag
---@return int32
function USoundscapeSubsystem:CheckColorPointDensity(Location, ColorPoint) end
---@param PaletteCollectionName FName
---@param PaletteCollection FSoundscapePaletteCollection
---@return boolean
function USoundscapeSubsystem:AddPaletteCollection(PaletteCollectionName, PaletteCollection) end
---@param ColorPointCollectionName FName
---@param ColorPointCollection FSoundscapeColorPointCollection
function USoundscapeSubsystem:AddColorPointCollection(ColorPointCollectionName, ColorPointCollection) end


